'''
Created on 24.10.2017

@author: PRORJM
'''

class Resource(object):
    '''
    Resource represents a source of primary energy for the systems investigated. 
    
        name            :   name of the resource, e.g. Fossil (HFO) for fossil heavy fuel oil
        availability    :   availability time series, irradiation for sun, price for all others
        enabled         :   whether the resource is enabled (done by multiplying/dividing costs/resources)
    
    to be added later if necessary: energy content..
    '''

    def __init__(self, name, avail, proj):
        self.name = name
        self.availability = avail
        self.projection = proj
        self.enabled = True
        
    def setAvailability(self, avail):
        self.availability = avail
        
    def disable(self):
        if self.enabled == False:
            print("Resource already disabled!")
        else:
            if self.name == "Sun":
                for i in range(0, len(self.availability)):
                    self.availability[i] = self.availability[i] / 1000000
            else:
                for i in range(0, len(self.availability)):
                    self.availability[i] = self.availability[i] * 1000
        self.enabled = False
        print("Resource "+ self.name+ " disabled!" )
        
    def enable(self):
        if self.enabled:
            print("Resource already enabled!")
        else:
            if self.name == "Sun":
                for i in range(0, len(self.availability)):
                    self.availability[i] = self.availability[i] * 1000000
            else:
                for i in range(0, len(self.availability)):
                    self.availability[i] = self.availability[i] / 1000
        self.enabled = True
        print("Resource "+ self.name+ " enabled!" )
            